<?php

/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/11/19
 * Time: 21:31
 */
class SessionDbSaveHandler {

    public $host;
    public $user;
    public $password;
    public $database;
    public $table = 'session';

    /**
     * @var PDO
     */
    public static $db;


    public function __construct($host, $user, $password, $database, $table = '') {

        $this->host = $host;
        $this->user = $user;
        $this->password = $password;
        $this->database = $database;
        $table && $this->table = $table;

        //自动注册session 保存到数据库
        session_set_save_handler(
            [$this, 'open'],
            [$this, 'close'],
            [$this, 'read'],
            [$this, 'write'],
            [$this, 'destroy'],
            [$this, 'gc']
        );

        $this->connection();
    }


    private function connection() {
        if (!static::$db) {
            $dsn = 'mysql:host=' . $this->host . ';dbname=' . $this->database;
            $params = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ];
            static::$db = new PDO($dsn, $this->user, $this->password, $params);
        }
    }

    /**
     * 打开session
     * @param $path
     * @param $id
     */
    public function open($path, $id) {

    }

    /**
     * 关闭session
     */
    public function close() {
        static::$db = null;
    }

    /**
     * 读取session
     * @param $id
     * @return string
     */
    public function read($id) {
        $sql = 'select * from session where sessionid=?';
        $statement = self::$db->prepare($sql);
        $statement->execute([$id]);
        $data = $statement->fetch(PDO::FETCH_OBJ);

        return $data ? $data->content : '';
    }

    /**
     * 保存session 或更新session
     * @param $id
     * @param $data
     * @return int
     */
    public function write($id, $data) {
        $sql = 'replace into session(`sessionid`,`content`,`ip`,`createtime`)values(?,?,?,?)';
        $statement = self::$db->prepare($sql);
        $result = $statement->execute([$id, $data, $this->ip2long(), time()]);
        if ($result) {
            return $statement->rowCount();
        }
    }

    /**
     * @param $id
     * @return int
     */
    public function destroy($id) {
        $sql = 'delete from session where sessionid=?';
        $statement = self::$db->prepare($sql);
        $statement->execute([$id]);
        return $statement->rowCount();
    }

    /**
     * 定期自动回收
     * @param $lifetime
     * @return int
     */
    public function gc($lifetime) {
        $sql = 'delete from session where createtime<?';
        $statement = self::$db->prepare($sql);
        $statement->execute([time() - $lifetime]);
        return $statement->rowCount();
    }

    public function __destruct() {
        $this->host = null;
        $this->user = null;
        $this->password = null;
        $this->database = null;
        session_write_close();
    }

    private function ip2long($ip = null) {
        return sprintf('%u', is_null($ip) ? $_SERVER['REMOTE_ADDR'] : $ip);
    }

}